<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMessagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('ch_messages')) {
            Schema::create('ch_messages', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('type');
                $table->bigInteger('from_id');
                $table->bigInteger('to_id');
                $table->string('body', 5000)->nullable();
                $table->string('attachment')->nullable();
                $table->boolean('seen')->default(false);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ch_messages');
    }
}
